%% Affichage des d�calages sur les voies correspondant aux micros acquis par le syst�me
% avec la commande Delay = 0
% mai 2021
% Donn�es acquises sur une courte dur�e (0.1 s suffit) avec le param�tre
% n_delay = 0, en format int32, uniquement des micros et pas de voies 
% analogiques, avec �ventuellement le compteur A
clear all
close all
%% VALEURS A ADAPTER
name = 'test1';
%% Lecture de l'en-t�te
name_en_tete = strcat(name, ".Mu");
fid = fopen(name_en_tete,'rb');
header.annee = fread(fid,1,'uint16');
header.mois = fread(fid,1,'uint16');
header.jour_semaine = fread(fid,1,'uint16');
header.jour = fread(fid,1,'uint16');
header.heure = fread(fid,1,'uint16');
header.minute = fread(fid,1,'uint16');
header.seconde = fread(fid,1,'uint16');
header.ms = fread(fid,1,'uint16');
header.micros = fread(fid,1024,'uint8');
header.VA = fread(fid,16,'uint8');
header.compteurs = fread(fid,4,'uint8');
header.frequence = fread(fid,1,'single');
header.nb_ech = fread(fid,1,'uint32');
header.duree = fread(fid,1,'single');
header.type = fread(fid,1,'uint8');
header.commentaires = fread(fid,1024,'*char');
fclose(fid);
if (header.type ~= 0)
    disp('Les donn�es ne sont pas en format Int32')
    return    
end
%%  Lecture donn�es
nb_micros =  sum(header.micros);
nb_VA = sum(header.VA);
nb_voies = nb_micros + nb_VA + header.compteurs(1);
if (sum(header.compteurs(2:4)) > 0)
    disp('Pr�sence de compteur(s) B, C, D. Enregistrement � refaire !');
    return
end
if (nb_micros == 0)
    disp('Pas de micro acquis. Enregistrement � refaire !');
    return
end
if (nb_VA > 0)
    disp('Des voies analogiques acquises. Enregistrement � refaire !');
    return
end
nb_ech = header.nb_ech;
name_dat = strcat(name,'.dat');
fid = fopen(name_dat,'rb');
mat=fread(fid,nb_ech*nb_voies,'*uint32');
fclose(fid);
mat=reshape(mat,nb_voies,[]);
%% Elimination du compteur A
if (header.compteurs(1) == 1)
    mat = mat(2:end,:);
    nb_voies = nb_voies - 1;
end
%% Extraction des digits
% On fait la moyenne (sur l'ensemble des �chantillons) des valeurs de 
% chaque digit
% lors de la num�risation au niveau des micros, les premiers digits �
% arriver sur les 24 sont ceux de poids fort (donc le signe en premier)
bits=zeros(nb_voies,24);
for i = 1 : 24
   bits(:,25-i) = mean(bitget(mat(:,:),i),2);
end
%% Affichage
scrsz = get(0,'ScreenSize');    %d�termination de la taille de l'�cran
figure('Position',[scrsz(3)/8 scrsz(4)/8 3*scrsz(3)/4 3*scrsz(4)/4],...
    'NumberTitle','off','Name','D�calages','Color','White');
imagesc(1:24,1:nb_micros,bits,[0 1]);
ax = gca;
set(gca,'FontName','Century Gothic','FontSize',14);
ylabel('Micro');
xlabel('Coup Horloge (MCK)');
colormap jet
colorbar
xticks([0:24])
ax.TickDir = 'out';
axis xy;